// Autor: Frane Kurtovic

#include <iostream>
#include <algorithm>
#include <cassert>
#include <cstring>

using namespace std;

typedef pair <int, int> par;
typedef long long llint;
const int MXR = 301;
const int D = 5;
const int MAX_SCORE = (4 * D + 1);

char mat[MXR][MXR];
int values[MXR][MXR];
int rows, cols;
int row_sums[MXR][MXR], col_sums[MXR][MXR];
int scores[MAX_SCORE + 1], scores_old[MAX_SCORE + 1];
llint total_cnt[2 * MAX_SCORE + 1];

int is_target(int r, int c) {
  if (r < 0 || c < 0 || r >= rows || c >= cols) return 0;
  if (mat[r][c] == '.') return 0;
  return 1;
}

inline bool ok(int r, int c) {
  return r >= 0 && c >= 0 && r < rows && c < cols;
}

int count_mem[MXR][MXR];
int count(int r, int c) {
  if (!ok(r, c)) return 0;
  if (count_mem[r][c] != -1) return count_mem[r][c];
  int ret = 0;
  for (int d = -D; d <= D; d++) {
    if (d != 0) {
      ret += is_target(r, c + d) + is_target(r + d, c);
    } else {
      ret += is_target(r, c);
    }
  }
  return count_mem[r][c] = ret;
}

int sum_row(int row, int l, int r) {
  if (r < l) return 0;
  if (l >= cols || r < 0) return 0;
  if (r >= cols) r = cols - 1;
  if (l < 0) l = 0;
  return row_sums[row][r] - row_sums[row][l] + values[row][l];
}

int sum_col(int col, int l, int r) {
  if (r < l) return 0;
  if (l >= rows || r < 0) return 0;
  if (r >= rows) r = rows - 1;
  if (l < 0) l = 0;
  return col_sums[r][col] - col_sums[l][col] + values[l][col];
}

void canonize(int& a, int& b) {
  if (a > b) {
    int t = a;
    a = b;
    b = t;
  }
}

int intersect_part(int row_h, int col_h, int row_v, int col_v) {
  if (col_v < col_h - D || col_v > col_h + D) return 0;
  if (row_h < row_v - D || row_h > row_v + D) return 0;
  if (row_h < 0 || row_h >= rows || col_v < 0 || col_v >= cols) return 0;
  return values[row_h][col_v];
}

int intersect(int r1, int c1, int r2, int c2) {
  if (r1 == r2) {
    canonize(c1, c2);
    return sum_row(r1, c2 - D, c1 + D);
  } else if (c1 == c2) {
    canonize(r1, r2);
    return sum_col(c1, r2 - D, r1 + D);
  }
  return intersect_part(r1, c1, r2, c2) + intersect_part(r2, c2, r1, c1);
}

int main() {
  memset(count_mem, -1, sizeof(count_mem));
  cin >> rows >> cols;
  for (int i = 0; i < rows; i++) {
    cin >> mat[i];
    for (int j = 0; j < cols; j++) {
      values[i][j] = is_target(i, j);
      if (j != 0) row_sums[i][j] = row_sums[i][j - 1];
      row_sums[i][j] += values[i][j];
      if (i != 0) col_sums[i][j] = col_sums[i - 1][j];
      col_sums[i][j] += values[i][j];
    }
  }
  for (int i = 0; i < rows; i++) {
    for (int j = 0; j < cols; j++) {
      int score = count(i, j);
      scores[score]++;
    }
  }

  int mx = 0;
  for (int i = 0; i < rows; i++) {
    for (int j = 0; j < cols; j++) {
      memcpy(scores_old, scores, sizeof(scores));
      int score = count(i, j);
      scores[score]--;
      // prolazak po svim bombama s kojima se ova bomba sijece
      for (int dr = -2 * D; dr <= 2 * D; dr++) {
        for (int dc = -2 * D; dc <= 2 * D; dc++) {
          if (dr == 0 && dc == 0) continue;
          if (!ok(i + dr, j + dc)) continue;
          int count_curr = count(i + dr, j + dc);
          int v = score + count_curr - intersect(i, j, i + dr, j + dc);
          // cout << "(" << i << ", " << j << ") (" << dr << ", " << dc << ") " << score << " " << count(i + dr, j + dc) << " " << intersect(i, j, i + dr, j + dc) << endl;
          mx = max(mx, v);
          scores[count_curr]--;
          total_cnt[v]++;
        }
      }
      for (int s = 0; s <= MAX_SCORE; s++) {
        total_cnt[s + score] += scores[s];
      }
      memcpy(scores, scores_old, sizeof(scores));
    }
  }
  for (int s = 2 * MAX_SCORE; s >= 0; s--) {
    if (total_cnt[s] > 0) {
      cout << s << endl << total_cnt[s] / 2 << endl;
      break;
    }
  }
  llint sum = 0;
  for (int s = 2 * MAX_SCORE; s >= 0; s--) {
    sum += total_cnt[s];
  }
  llint p = rows * cols;
  assert(sum == p * (p - 1));
  return 0;
}
